// SingleEntry.cpp : Implementierungsdatei
//

#include "SingleEntry.h"
#include <vcl.h>

// BSingleEntry

BSingleEntry::BSingleEntry()
{
	ParentList = NULL;
}

BSingleEntry::BSingleEntry(const String EName)
  : FEntryName(EName), ParentList(NULL)
{
}


BSingleEntry::BSingleEntry(const String EName, BSingleEntry* Parent)
 : FEntryName(EName), ParentList(Parent)
{
}


String BSingleEntry::FullName()
{
  if (ParentList != NULL) return ParentList->FullName()+'\\'+ EntryName();
	else return EntryName();
}

String BSingleEntry::GetDisplayName()
{
  return FEntryName;
}

BSingleEntry* BSingleEntry::AddEntry(const String EName)
{
  return NULL;
}

BSingleEntry* BSingleEntry::AddNode(const String NName)
{
  return AddEntry(NName);
}


BSingleEntry* BSingleEntry::FindEntry(const String PartialName)
{
  if (FEntryName == PartialName)
		return this;
	else
		return NULL;
}


// BListEntry

BListEntry::BListEntry()
{
   EntryList = new TList();
}

BListEntry::BListEntry(String EName) : BSingleEntry(EName)
{
  EntryList = new TList();
}

BListEntry::BListEntry(String EName, BSingleEntry* Parent)
: BSingleEntry(EName, Parent)
{
  EntryList = new TList();
}

// In C++ ein Destruktor ntig, der die Listen durchluft
BListEntry::~BListEntry()
{
  for (int x = 0; x < EntryList->Count; x++)
    delete EntryList->Items[x];
  delete EntryList; // die Liste daselbst
}

BSingleEntry* BListEntry::FindEntry(const String PartialName)
{
  BSingleEntry* Result = BSingleEntry::FindEntry(PartialName);

  if (Result == NULL)
  	for (int x = 0; x < EntryList->Count; x++)
          { BSingleEntry* E = (BSingleEntry *)EntryList->Items[x];

            Result = E->FindEntry(PartialName);
	    if (Result != NULL)
	    	break;
          }
  return Result;
}

BSingleEntry* BListEntry::AddEntry(const String EName)
{ BSingleEntry* Result = new BSingleEntry(EName, this);

  EntryList->Add(Result);
  return Result;
}

BSingleEntry* BListEntry::AddNode(const String NName)
{ BListEntry* Result = new BListEntry(NName, this);

  EntryList->Add(Result);
  return Result;
}

BSingleEntry* BListEntry::GetEntry(int Index)
{
  if (Index < 0 || Index >= EntryList->Count) return NULL;
    else return (BSingleEntry*) EntryList->Items[Index];
}

String BListEntry::GetDisplayName()
{
  return BSingleEntry::GetDisplayName() + " (LIST)";
}


